/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.block.craft.IStoveBlock;
import cloud.lemonslice.teastory.block.craft.WoodenFrameBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public enum BambooTrayMode {
    IN_RAIN,
    OUTDOORS,
    INDOORS,
    BAKE,
    PROCESS;


    public static BambooTrayMode getMode(Level world, BlockPos pos) {
        if (BambooTrayMode.isInRain(world, pos)) {
            return IN_RAIN;
        }
        if (BambooTrayMode.hasHeat(world, pos)) {
            return BAKE;
        }
        if (BambooTrayMode.isOnFrame(world, pos)) {
            return PROCESS;
        }
        if (BambooTrayMode.isInSun(world, pos)) {
            return OUTDOORS;
        }
        return INDOORS;
    }

    public static boolean isInRain(Level world, BlockPos pos) {
        return world.m_46758_(pos.m_7494_());
    }

    public static boolean hasHeat(Level world, BlockPos pos) {
        return IStoveBlock.isBurning(world, pos.m_7495_());
    }

    public static boolean isInSun(Level world, BlockPos pos) {
        return world.m_45527_(pos);
    }

    public static boolean isLevelRaining(Level world) {
        return world.m_46471_();
    }

    public static boolean isOnFrame(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60734_() instanceof WoodenFrameBlock;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public Component getTranslationKey() {
        return Component.m_237115_((String)("info.teastory.bamboo_tray.mode." + this));
    }
}

